import java.util.Properties

plugins {
    alias(libs.plugins.android.application)
    alias(libs.plugins.kotlin.android)
    alias(libs.plugins.kotlin.compose)
    id("org.jetbrains.kotlin.plugin.serialization") version "1.9.10"
    id("org.jlleitschuh.gradle.ktlint") version "12.1.0"
}

tasks.register("copyTestAssets", Copy::class) {
    from(provider { rootProject.rootDir.parentFile.parentFile.resolve("test_assets") })
    // Change this line to copy directly into the assets source set
    into("$projectDir/src/main/assets")
    include(
        "4k-resolutaion.jpg",
        "10001664.jpg",
        "highres.jpg",
        "just_plate.png",
        "just_plate2.jpg",
        "multi-cars.jpg",
        "rear.jpg",
        "rotated.jpg",
        "simple.jpg",
        "tall-red.jpg",
        "tesla_model3.jpg",
    )
}

tasks.named("preBuild") {
    dependsOn("copyTestAssets")
}

val localProps =
    Properties().apply {
        val f = rootProject.file("local.properties")
        if (f.exists()) f.inputStream().use { load(it) }
    }

android {
    namespace = "com.parkpow.platerec"
    compileSdk = 36

    defaultConfig {
        applicationId = "com.parkpow.platerec"
        minSdk = 24
        targetSdk = 36
        versionCode = 1
        versionName = "1.0"

        buildFeatures {
            buildConfig = true
        }

        ndk {
            abiFilters += listOf("arm64-v8a")
        }

        buildConfigField(
            "String",
            "LICENSE_KEY",
            "\"${localProps.getProperty("LICENSE_KEY", "")}\"",
        )
        buildConfigField(
            "String",
            "TOKEN",
            "\"${localProps.getProperty("TOKEN", "")}\"",
        )
    }

    ndkVersion = "23.2.8568313"

    signingConfigs {
        create("release") {
            storeFile = file("test-key.jks")
            storePassword = "test-store-password" // pragma: allowlist secret
            keyAlias = "test-alias"
            keyPassword = "test-store-password" // pragma: allowlist secret
        }
    }
    buildTypes {
        release {
            signingConfig = signingConfigs.getByName("release")
            isMinifyEnabled = false
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro",
            )
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }
    kotlinOptions {
        jvmTarget = "11"
    }
    buildFeatures {
        compose = true
    }
    sourceSets {
        getByName("main") {
            jniLibs.srcDirs("src/main/jniLibs")
            assets.srcDirs("src/main/assets")
        }
    }
}

dependencies {

    implementation(libs.androidx.core.ktx)
    implementation(libs.androidx.lifecycle.runtime.ktx)
    implementation(libs.androidx.activity.compose)
    implementation(platform(libs.androidx.compose.bom))
    implementation(libs.androidx.ui)
    implementation(libs.androidx.ui.graphics)
    implementation(libs.androidx.ui.tooling.preview)
    implementation(libs.androidx.material3)
    debugImplementation(libs.androidx.ui.tooling)
    implementation("org.jetbrains.kotlinx:kotlinx-serialization-json:1.6.0")
}
