package com.parkpow.platerec

import android.content.Context
import android.content.res.AssetManager
import java.time.Instant
import java.time.LocalDateTime
import java.time.ZoneId
import java.time.format.DateTimeFormatter

object Snapshot {
    init {
        System.loadLibrary("PlateRec")
    }

    @JvmStatic
    fun enginePrepare(
        context: Context,
        token: String,
        licenseKey: String,
        writablePath: String,
        assetManager: AssetManager,
    ): Boolean {
        return try {
            prepare(context, token, licenseKey, writablePath, assetManager)
        } catch (e: Exception) {
            false
        }
    }

    @JvmStatic
    fun engineProc(
        filename: String,
        configJson: String,
        regions: Array<String>,
        doMmc: Boolean,
        doDirection: Boolean,
        cameraId: String,
        timestamp: String,
    ): String {
        return try {
            proc(filename, configJson, regions, doMmc, doDirection, cameraId, timestamp)
        } catch (e: Exception) {
            ""
        }
    }

    @JvmStatic
    fun engineOnStop(context: Context) {
        try {
            checkpoint(context)
        } catch (e: Exception) {
        }
    }

    @JvmStatic
    private external fun prepare(
        context: Context,
        token: String,
        license_key: String,
        writable_path: String,
        assetManager: AssetManager,
    ): Boolean

    @JvmStatic
    private external fun proc(
        filename: String,
        config_json: String,
        regions: Array<String>,
        do_mmc: Boolean,
        do_direction: Boolean,
        camera_id: String,
        timestamp: String,
    ): String

    @JvmStatic
    private external fun checkpoint(context: Context): Void

    val currentTimestamp: String
        get() {
            val now = Instant.now()

            // Convert to microseconds
            val micros = (now.nano / 1000).toLong()

            // Convert to local date-time
            val localDateTime = LocalDateTime.ofInstant(now, ZoneId.systemDefault())

            // Format time (without microseconds)
            val formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")
            val formattedTime = localDateTime.format(formatter)

            // Combine with microseconds
            return String.format("%s.%06d", formattedTime, micros)
        }
}
